import numpy as np
from scipy import constants
import csv
import scipy as sp

def scan_range(lambda_mean, alp, relative_position):
    alpha = np.radians(alp)
    min_e = 100.0
    min_o = 100.0

    with open('Tamosauskas-e.csv', 'r') as extraordinary:
        reader = csv.reader(extraordinary)
        my_list = list(reader)
        print(my_list)

        for i in range(len(my_list)):

            if abs(float(my_list[i][0]) - lambda_mean) < min_e:
                min_e = abs(float(my_list[i][0]) - lambda_mean)
                n_e1 = my_list[i][1]
                n_e0 = my_list[i - 1][1]
                n_e2 = my_list[i + 1][1]
                x0 = my_list[i - 1][0]
                x1 = my_list[i][0]
                x2 = my_list[i + 1][0]

        y = [float(n_e0), float(n_e1), float(n_e2)]
        x = [float(x0), float(x1), float(x2)]

        print(x)
        print(y)
        f1 = sp.interpolate.interp1d(x, y, kind='linear')

        n_e = f1(lambda_mean)
        print(n_e)
        extraordinary.close()

    with open('Tamosauskas-o.csv', 'r') as ordinary:
        reader = csv.reader(ordinary)
        my_list = list(reader)
        print(my_list)

        for i in range(len(my_list)):

            if abs(float(my_list[i][0]) - lambda_mean) < min_o:
                min_o = abs(float(my_list[i][0]) - lambda_mean)
                n_o1 = my_list[i][1]
                n_o0 = my_list[i - 1][1]
                n_o2 = my_list[i + 1][1]
                x0 = my_list[i - 1][0]
                x1 = my_list[i][0]
                x2 = my_list[i + 1][0]

        y = [float(n_o0), float(n_o1), float(n_o2)]
        x = [float(x0), float(x1), float(x2)]

        print(x)
        print(y)
        f1 = sp.interpolate.interp1d(x, y, kind='linear')

        n_o = f1(lambda_mean)
        print(n_o)
        ordinary.close()

    delta_n = n_e - n_o

    delay = delta_n*relative_position*np.sin(alpha)/constants.c

    return delay
